/* oscil~.c  one float inlet, one signal outlet
** direct sin function call
** 02/11/04 IF
** 04/10/26 IF
*/

#include "ext.h"    // Required for all Max external objects
#include "z_dsp.h"  // Required for all MSP external objects

#define DEF_FREQ 440

void *oscil_class;

typedef struct _oscil 	// Data structure for this object
{
    t_pxobject t_obj;
    t_float t_freq;  // current frequenct
    t_float t_sr;	// smapling rate
    t_float t_ptr;	// current phase
} t_oscil;

void *oscil_new(float freq);
t_int *oscil_perform(t_int *w);
void oscil_dsp(t_oscil *x, t_signal **sp, short *count);
void oscil_float(t_oscil *x, t_float val);

int main(void)
{
    setup((t_messlist **)&oscil_class, (method)oscil_new, (method)dsp_free, (short)sizeof(t_oscil), 0L, A_DEFFLOAT, 0);
    addmess((method)oscil_dsp, "dsp", A_CANT, 0);
    addfloat((method)oscil_float);		
    dsp_initclass();						// in floatin()
	return(0);
}

void *oscil_new(float freq)
{
	t_oscil *x = (t_oscil *)newobject(oscil_class);
	if (freq != 0)
		x->t_freq = freq;
	else
		x->t_freq = DEF_FREQ;
	
	x->t_ptr = 0;
	dsp_setup((t_pxobject *)x, 0);			// left signal inlet, must come after floatin
	outlet_new((t_pxobject *)x, "signal");	// left signal outlet, must come after floatout
	return (x);
}

void oscil_float(t_oscil *x, t_float val)
{
	x->t_freq = val;
}
	
void oscil_dsp(t_oscil *x, t_signal **sp, short *count)
{
	x->t_sr = sp[0]->s_sr; 	// get sampling rate
	x->t_ptr = 0;			// phase
	dsp_add(oscil_perform, 3, sp[0]->s_vec, sp[0]->s_n, x);
}

t_int *oscil_perform(t_int *w)
{
	float p;
    t_float *out = (t_float *)(w[1]);
	int n = (int)(w[2]);
	t_oscil *x = (t_oscil *)w[3];
	float incr = TWOPI * x->t_freq / x->t_sr;

	p = x->t_ptr; // starting phase
	while (n--) 
	{
		*out++ = sin(p);
		p += incr;
		while (p > TWOPI)
			p -= TWOPI;
	}
	x->t_ptr = p; // ending phase
	
    return (w + 4); // always add one more than the 2nd argument in dsp_add()
}


